/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.fw.util.DateTimePattern;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ItemDescriptor;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class EventLogInitTable
implements Serializable {
    private static final String TRACE_MASKT = "XLOGDCET";
    private static final String TRACE_MASKF = "XLOGDCEF";
    private static final String TRACE_MASKD = "XLOGDCED";
    private static DateFormat _dateFormat;
    private static DateFormat _timeFormat;

    public static void setEventTableData(EventLogData eventLogData, int i, ItemDescriptor[] newRow) {
        Trace.trace(TRACE_MASKD, "-> setEventTableData() i=" + i);
        newRow[0].setName("EventId" + i);
        newRow[0].setTitle(eventLogData.getEventId());
        newRow[1].setName("Date" + i);
        Date timeStamp = eventLogData.getDate();
        if (timeStamp != null) {
            newRow[1].setTitle(_dateFormat.format(timeStamp));
        } else {
            newRow[1].setTitle("");
        }
        newRow[2].setName("Time" + i);
        if (timeStamp != null) {
            newRow[2].setTitle(_timeFormat.format(timeStamp));
        } else {
            newRow[2].setTitle("");
        }
        newRow[3].setName("Type" + i);
        newRow[3].setTitle(eventLogData.getType().toString());
        newRow[4].setName("Name" + i);
        newRow[4].setTitle(eventLogData.getName());
        Trace.trace(TRACE_MASKF, "EventId=[" + eventLogData.getName() + "] i=" + i);
        newRow[5].setName("Data" + i);
        String str = eventLogData.getData();
        if (str != null) {
            int strLen = str.length();
            Trace.trace(TRACE_MASKF, "DataStrLen=" + strLen);
            if (strLen == 0) {
                newRow[5].setTitle("");
            } else if (strLen > 60) {
                String newStr = str.substring(0, 60) + "...";
                newRow[5].setTitle(newStr);
                Trace.trace(TRACE_MASKF, "Data=[" + newStr + "] i=" + i + " strLen=" + strLen);
            } else {
                newRow[5].setTitle(eventLogData.getData());
                Trace.trace(TRACE_MASKF, "Data=[" + eventLogData.getData() + "] i=" + i + " strLen=" + strLen);
            }
        } else {
            newRow[5].setTitle("");
        }
    }

    public static ItemDescriptor[] setEventTableData(EventLogData eventLogData) {
        Trace.trace(TRACE_MASKD, "-> setEventTableData(eventLogData)");
        ItemDescriptor[] newRow = new ItemDescriptor[6];
        int j = 0;
        while (j < 6) {
            newRow[j] = new ItemDescriptor();
            ++j;
        }
        EventLogInitTable.setEventTableData(eventLogData, 0, newRow);
        Trace.trace(TRACE_MASKD, "-> setEventTableData(eventLogData)");
        return newRow;
    }

    static {
        Trace.trace(TRACE_MASKD, " in static code in EventLogInitTable()");
        Locale loc = Locale.getDefault();
        if (loc == null) {
            Trace.trace(TRACE_MASKF, " LOCALE IS NULL..");
        }
        _dateFormat = DateTimePattern.getDatePattern(loc);
        _timeFormat = DateTimePattern.getTimeWithMillisecondsPattern(loc);
        Trace.trace(TRACE_MASKD, " out of static code in EventLogInitTable()");
    }
}

